/////////////////////////////////////////////////////////////////////////
#include <18F45K80.h>

#use delay(clock=8000000) //8MHz

#include "pin_defines.h"
#include <1wire.c>
#include <ds1820.c>

//#fuses NOWDT,NOPROTECT,NODEBUG, NOXINST, NOBROWNOUT
#Fuses NOPLLEN,NOPUT,NOIESO,NOFCMEN,NOBROWNOUT,NOWDT,NOEBTRB,NOEBTR,XT


void main() {
   int8 temperature=0, prev_temperature=0;

   int8 i=0;
   for (i=0; i<3; i++) {
      output_high( BUZZER );
      delay_ms(100);
      output_low( BUZZER );  
      delay_ms(100);
   }

   //for  10 bit resolution mod 
   onewire_write(0xCC);
   onewire_write(0x4E);

   onewire_write(125);
   onewire_write(-55); //this should be done for proper working of DS18B20
   onewire_write(127);

   onewire_reset();
   onewire_write(0xCC);
   onewire_write(0x48);
   delay_ms(15); 

   while (TRUE) {
      temperature = ds1820_read();
      if ( temperature != prev_temperature) {                                     // if temperature changes
         output_high( BUZZER );                                                   // then sound buzzer
      } else {
         output_low( BUZZER );                                                    //else stop buzzing
      } 
           
      prev_temperature = temperature;
      output_toggle(MISC_LED);
//      delay_ms(100);
   } 
}
